<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property string $sid
 * @property string $url
 * @property array $links
 */
class CallInstance extends InstanceResource {
    protected $_events = null;
    protected $_metrics = null;
    protected $_summary = null;

    /**
     * Initialize the CallInstance
     *
     * @param \Twilio\Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $sid The sid
     * @return \Twilio\Rest\Insights\V1\CallInstance
     */
    public function __construct(Version $version, array $payload, $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = array(
            'sid' => Values::array_get($payload, 'sid'),
            'url' => Values::array_get($payload, 'url'),
            'links' => Values::array_get($payload, 'links'),
        );

        $this->solution = array('sid' => $sid ?: $this->properties['sid'], );
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return \Twilio\Rest\Insights\V1\CallContext Context for this CallInstance
     */
    protected function proxy() {
        if (!$this->context) {
            $this->context = new CallContext($this->version, $this->solution['sid']);
        }

        return $this->context;
    }

    /**
     * Fetch a CallInstance
     *
     * @return CallInstance Fetched CallInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        return $this->proxy()->fetch();
    }

    /**
     * Access the events
     *
     * @return \Twilio\Rest\Insights\V1\Call\EventList
     */
    protected function getEvents() {
        return $this->proxy()->events;
    }

    /**
     * Access the metrics
     *
     * @return \Twilio\Rest\Insights\V1\Call\MetricList
     */
    protected function getMetrics() {
        return $this->proxy()->metrics;
    }

    /**
     * Access the summary
     *
     * @return \Twilio\Rest\Insights\V1\Call\CallSummaryList
     */
    protected function getSummary() {
        return $this->proxy()->summary;
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get($name) {
        if (array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Insights.V1.CallInstance ' . implode(' ', $context) . ']';
    }
}